//
//  IDPathInfo.h
//  iDeviceFramework
//
//  Created by Chris Devor on 3/1/12.
//  Copyright (c) 2012 Macroplant. All rights reserved.
//

#import <Foundation/Foundation.h>

@class IDIDevice;

typedef enum _IDPathInfoType {
    IDPathInfoType_file,
    IDPathInfoType_directory,
    IDPathInfoType_hardLink,
    IDPathInfoType_symbolicLink,
} IDPathInfoType;

/**
 Data class for info in a given file/folder on the device
 */
@interface IDPathInfo : NSObject
{
    
    IDIDevice *idevice;
    NSString *service;
    NSDictionary *rawInfoDict;
    NSString *fullPath;
    
    IDPathInfo *linkTargetPathInfo;
}

/** The full path for the item */
@property (readonly) NSString *fullPath;

/** The name of the connection service, like com.apple.AFC, or an app's identifier */
@property (readonly) NSString *service;

/** The device */
@property (readonly) IDIDevice *idevice;

- (id) initWithPath:(NSString *) itemPath device:(IDIDevice *) device serviceName:(NSString *) serviceName;
+ (IDPathInfo *) pathInfotWithPath:(NSString *) itemPath device:(IDIDevice *) device serviceName:(NSString *) serviceName;

/**
 File, directory, link
 @return the item type
 */
- (IDPathInfoType) pathInfoType;

/** 
 Date last modified
 @return date modified
 */
- (NSDate *) dateModified;

/**
 Date first created
 @return date created
 */
- (NSDate *) dateCreated;

/**
 File size in bytes
 @return file size
 */
- (NSNumber *) length;

/**
 If it's a link, the path for the link target
 @return path to link target; nil if not a link
 */
- (NSString *) linkTargetPath;

/**
 If it's a hard link, number of hard links
 @return number of hard links, nil if not a hard link
 */
- (NSNumber *) numberOfHardLinks;

/**
 Is a hidden file/folder (usually just checks if it begins with .)
 @return YES if hidden
 */
- (BOOL) isHidden;

/**
 Is a directory
 @return YES if directory, NO if anything else
 */
- (BOOL) isDirectory;

/**
 Is a file
 @return YES if file, NO if anything else
 */
- (BOOL) isFile;

/**
 Is a symbolic or hard link
 @return YES if link, NO if anything else
 */
- (BOOL) isLink;

/**
 Get the directory children.
 
 @return array of IDPathInfo's in the directory, or nil if not a directory
 
 @discussion This may take some time to iterate the directory contents, if that hasn't been done yet. If it has, then this just returns the saved list
 */
- (NSArray *) getChildPathInfos;

/**
 Make sure the item still exists
 */
- (BOOL) exists;

/**
 Copy the file to a path on the local computer. Does not return until the operation completes
 */
- (BOOL) copyToComputer:(NSString *)destinationPathOnComputer;

/**
 All the file/folder info we get, in the keys they come in
 */
- (NSDictionary *) rawInfoDict;


@end
